//shading:         constant color
//lighting model:  none
//lighting type:   none

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer (EX9)
float4x4 tWVP: WORLDVIEWPROJECTION;

//material properties

//texture
texture Tex <string uiname="Texture";>;
sampler3D Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = point;         //sampler states
    MinFilter = point;
    MagFilter = point;
    AddressU = Wrap;
    AddressV = Wrap;
};


texture Texc <string uiname="Texturec";>;
sampler3D Sampc = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Texc);          //apply a texture to the sampler
    MipFilter = point;         //sampler states
    MinFilter = point;
    MagFilter = point;
    AddressU = clamp;
    AddressV = clamp;
};
texture Textg <string uiname="Texture gradient";>;
sampler3D Sampg = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Textg);          //apply a texture to the sampler
    MipFilter = point;         //sampler states
    MinFilter = point;
    MagFilter = point;
    AddressU = clamp;
    AddressV = clamp;
};
int dims;




float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;
 float4x4 tCol;


//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos : POSITION;
    float4 TexCd : TEXCOORD0;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------

vs2ps VS(
    float4 Pos : POSITION,
    float4 TexCd : TEXCOORD0)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;
    Out.TexCd =mul( Pos, tTex);
    //transform position
    Out.Pos = mul(Pos, tWVP);

    //transform texturecoordinates


    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------



 float4 PS1(vs2ps In): COLOR
{

     float3 xyzNorm = In.TexCd*dims;
     int xi = int(floor(xyzNorm.x));
     int yi = int(floor(xyzNorm.y));
     int zi = int(floor(xyzNorm.z));
     float xf = xyzNorm.x - float(xi);
     float yf = xyzNorm.y - float(yi);
     float zf = xyzNorm.z - float(zi);
     float radius = 5;
     float2 cell = 0;
     float4 colo = 1;
     float4 colo2 =1;
     float4 colhue ;
     float f1 =10000;
     float f2 =10000;
     float priority =99999999;

         for (int y = -1 ; y<=1; y++ )
               {for (int x = -1 ; x<=1; x++ )
                   {for (int z = -1 ; z<=1; z++ )
                   {
                    float u= float(xi +x +yi+y * 1)/dims;
                    float v= float(yi +y -xi+x *-1)/dims;
                     float w= float(zi +z -yi+y *-1)/dims;
                    float3 uvwFract = frac(float3(u,v,w));

                    float3 cell = tex3D(Samp, uvwFract);
                    float4 colo2 = tex3D(Sampc, uvwFract);
                    cell.x +=(float(x)-xf);
                    cell.y +=(float(y)-yf);
                    cell.z +=(float(z)-zf);
                    float dist =  dot(cell,cell);


                     radius = ((dist >radius) ? radius : dist);

                     if ( dist < f1 ){
                     f2 = f1;

                     f1 = dist;
                     colhue = colo2;
                 }   }
              }
          }

     float3 uv ;
     uv.x = 1-(f1);
     uv.y = 0;
     uv.z=0;

    colo = tex3D(Sampg, uv );
    colo *= colhue;
    colo.a=1;
 return mul(colo,tCol) ;
}

  float4 PS2(vs2ps In): COLOR
{

     float3 xyzNorm = In.TexCd*dims;
     int xi = int(floor(xyzNorm.x));
     int yi = int(floor(xyzNorm.y));
     int zi = int(floor(xyzNorm.z));
     float xf = xyzNorm.x - float(xi);
     float yf = xyzNorm.y - float(yi);
     float zf = xyzNorm.z - float(zi);
     float radius = 5;
     float2 cell = 0;
     float4 colo = 1;
     float4 colhue ;
     float f1 =10000;
     float f2 =10000;
     float priority =99999999;

         for (int y = -1 ; y<=1; y++ )
               {for (int x = -1 ; x<=1; x++ )
                   {for (int z = -1 ; z<=1; z++ )
                   {
                    float u= float(xi +x +yi+y * 1)/dims;
                    float v= float(yi +y -xi+x *-1)/dims;
                     float w= float(zi +z -yi+y *-1)/dims;
                    float3 uvwFract = frac(float3(u,v,w));

                    float4 cell = tex3D(Samp, uvwFract);
                    float4 colo3 = tex3D(Sampc, uvwFract);
                    cell.x +=(float(x)-xf);
                    cell.y +=(float(y)-yf);
                    cell.z +=(float(z)-zf);
                    float dist =  dot(cell,cell);


                     radius = ((dist >radius) ? radius : dist);

                  if ( dist < f1 ){
                     f2 = f1;

                     f1 = dist;
                     colhue = colo3;
                     } else if (dist <f2)  {

                     f2 = dist;

                    }

                 }
              }
          }

    colo=1;

    colo =(f1/f2)*1.03 ;
    if(colo.r<1) colo = 0;
     colo.a = 1;
 return mul(colo,tCol) ;
}

  float4 PS3(vs2ps In): COLOR
{
    float3 xyzNorm = In.TexCd*dims;
     int xi = int(floor(xyzNorm.x));
     int yi = int(floor(xyzNorm.y));
     int zi = int(floor(xyzNorm.z));
     float xf = xyzNorm.x - float(xi);
     float yf = xyzNorm.y - float(yi);
     float zf = xyzNorm.z - float(zi);
     float radius = 5;
     float2 cell = 0;
     float4 colo = 1;
     float4 colhue ;
     float f1 =10000;
     float f2 =10000;
     float priority =99999999;

         for (int y = -1 ; y<=1; y++ )
               {for (int x = -1 ; x<=1; x++ )
                   {for (int z = -1 ; z<=1; z++ )
                   {
                    float u= float(xi +x +yi+y * 1)/dims;
                    float v= float(yi +y -xi+x *-1)/dims;
                     float w= float(zi +z -yi+y *-1)/dims;
                    float3 uvwFract = frac(float3(u,v,w));

                    float4 cell = tex3D(Samp, uvwFract);
                    float4 colo3 = tex3D(Sampc, uvwFract);
                    cell.x +=(float(x)-xf);
                    cell.y +=(float(y)-yf);
                    cell.z +=(float(z)-zf);
                    float dist =  dot(cell,cell);


                     radius = ((dist >radius) ? radius : dist);
                     if (dist < f1 ){
                     f2 = f1;

                     f1 = dist;
                     colo = 1-f1 ;
                     colhue = colo3;
                     } else if (dist <f2)  {

                     f2 = dist;

                         }
                      }
                    }
                  }



     float3 uv ;
     uv.x =  (f1 * f2)/4;
     uv.y = 0;
     uv.z=0;

    colo = tex3D(Sampg, uv );
    //colo *= colhue;
 return mul(colo,tCol) ;
}

  float4 PS4(vs2ps In): COLOR
{

     float3 xyzNorm = In.TexCd*dims;
     int xi = int(floor(xyzNorm.x));
     int yi = int(floor(xyzNorm.y));
     int zi = int(floor(xyzNorm.z));
     float xf = xyzNorm.x - float(xi);
     float yf = xyzNorm.y - float(yi);
     float zf = xyzNorm.z - float(zi);
     float radius = 5;
     float2 cell = 0;
     float4 colo = 1;
     float4 colhue ;
     float f1 =10000;
     float f2 =10000;
     float priority =99999999;

         for (int y = -1 ; y<=1; y++ )
               {for (int x = -1 ; x<=1; x++ )
                   {for (int z = -1 ; z<=1; z++ )
                   {
                    float u= float(xi +x +yi+y * 1)/dims;
                    float v= float(yi +y -xi+x *-1)/dims;
                     float w= float(zi +z -yi+y *-1)/dims;
                    float3 uvwFract = frac(float3(u,v,w));

                    float4 cell = tex3D(Samp, uvwFract);
                    float4 colo3 = tex3D(Sampc, uvwFract);
                    cell.x +=(float(x)-xf);
                    cell.y +=(float(y)-yf);
                    cell.z +=(float(z)-zf);
                    float dist =  dot(cell,cell);


                     radius = ((dist >radius) ? radius : dist);

                    if ( dist < f1 ){
                     f2 = f1;

                     f1 = dist;
                     colhue = colo3;
                     } else if (dist <f2)  {

                     f2 = dist;

                    }
                      }
                    }
                  }


     float3 uv ;
     uv.x = f2-(f1);
     uv.y = 0;
     uv.z=0;

    colo = tex3D(Sampg, uv );
    colo *= colhue;

 return mul(colo,tCol) ;
}


// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique cellnoise1
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_1 VS();
        PixelShader = compile ps_3_0 PS1();
    }
}

technique cellnoise2
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_1 VS();
        PixelShader = compile ps_3_0 PS2();
    }
}
technique cellnoise3
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_1 VS();
        PixelShader = compile ps_3_0 PS3();
    }
}
technique cellnoise4
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_1 VS();
        PixelShader = compile ps_3_0 PS4();
    }
}


///http://www.sanchtv.com
